<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class ActivityLogController extends Controller
{
    // 🔹 GET ALL
    public function index()
    {
        try {
            return response()->json([
                'status' => 'success',
                'data' => ActivityLog::with('user')->get()
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 CREATE
    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'U_Id' => 'required|exists:users_masters,U_Id',
                'FootPrint' => 'required|max:100',
                'StartDate' => 'required|date',
                'EndDate' => 'nullable|date|after_or_equal:StartDate'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 'validation_error',
                    'errors' => $validator->errors()
                ], 422);
            }

            $log = ActivityLog::create($request->all());

            return response()->json([
                'status' => 'success',
                'message' => 'Activity log created',
                'data' => $log
            ], 201);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 GET BY ID
    public function show($id)
    {
        try {
            $log = ActivityLog::find($id);

            if (!$log) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Activity log not found'
                ], 404);
            }

            return response()->json([
                'status' => 'success',
                'data' => $log
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 UPDATE
    public function update(Request $request, $id)
    {
        try {
            $log = ActivityLog::find($id);

            if (!$log) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Activity log not found'
                ], 404);
            }

            $validator = Validator::make($request->all(), [
                'U_Id' => 'required|exists:users_masters,U_Id',
                'FootPrint' => 'required|max:100',
                'StartDate' => 'required|date',
                'EndDate' => 'nullable|date|after_or_equal:StartDate'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 'validation_error',
                    'errors' => $validator->errors()
                ], 422);
            }

            $log->update($request->all());

            return response()->json([
                'status' => 'success',
                'message' => 'Activity log updated',
                'data' => $log
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 DELETE
    public function destroy($id)
    {
        try {
            $log = ActivityLog::find($id);

            if (!$log) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Activity log not found'
                ], 404);
            }

            $log->delete();

            return response()->json([
                'status' => 'success',
                'message' => 'Activity log deleted'
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
