<?php

namespace App\Http\Controllers;

use App\Models\InqStatusAction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class InqStatusActionController extends Controller
{
    // LIST
    public function index()
    {
        try {
            $data = InqStatusAction::with(['status','enquiry'])->orderBy('Inq_Act_Id','desc')->get();
            return response()->json(['status'=>'success','data'=>$data]);
        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // STORE
    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Inq_St_Id' => 'required|exists:inquiry_statuses,Inq_St_Id',
                'Inq_Id' => 'required|exists:inquiry_requests,Inq_Id',
                'Inq_Action' => 'required|string|max:255',
                'Send_By' => 'required|string|max:255',
                'Recepient' => 'required|string|max:255',
            ]);

            if ($validator->fails()) {
                return response()->json(['status'=>'validation_error','errors'=>$validator->errors()],422);
            }

            $data = InqStatusAction::create($request->only('Inq_St_Id','Inq_Id','Inq_Action','Send_By','Recepient'));

            return response()->json(['status'=>'success','message'=>'Action created','data'=>$data],201);
        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // SHOW
    public function show($id)
    {
        try {
            $data = InqStatusAction::with(['status','enquiry'])->find($id);

            if (!$data) {
                return response()->json(['status'=>'error','message'=>'Record not found'],404);
            }

            return response()->json(['status'=>'success','data'=>$data]);
        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // UPDATE
    public function update(Request $request, $id)
    {
        try {
            $data = InqStatusAction::find($id);

            if (!$data) {
                return response()->json(['status'=>'error','message'=>'Record not found'],404);
            }

            $validator = Validator::make($request->all(), [
                'Inq_St_Id' => 'required|exists:inquiry_statuses,Inq_St_Id',
                'Inq_Id' => 'required|exists:inquiry_requests,Inq_Id',
                'Inq_Action' => 'required|string|max:255',
                'Send_By' => 'required|string|max:255',
                'Recepient' => 'required|string|max:255',
            ]);

            if ($validator->fails()) {
                return response()->json(['status'=>'validation_error','errors'=>$validator->errors()],422);
            }

            $data->update($request->only('Inq_St_Id','Inq_Id','Inq_Action','Send_By','Recepient'));

            return response()->json(['status'=>'success','message'=>'Action updated','data'=>$data]);
        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // DELETE
    public function destroy($id)
    {
        try {
            $data = InqStatusAction::find($id);

            if (!$data) {
                return response()->json(['status'=>'error','message'=>'Record not found'],404);
            }

            $data->delete();

            return response()->json(['status'=>'success','message'=>'Action deleted']);
        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }
}
