<?php

namespace App\Http\Controllers;

use App\Models\InqStatusViewer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class InqStatusViewerController extends Controller
{
    // 🔹 LIST
    public function index()
    {
        try {
            return response()->json([
                'status' => 'success',
                'data' => InqStatusViewer::with('user', 'inq_st', 'inq_Id')->get()
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 CREATE
    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Inq_St_Id' => 'required|exists:inquiry_statuses,Inq_St_Id',
                'U_Id'      => 'required|exists:users_masters,U_Id',
                'Inq_Id'    => 'required|exists:inquiry_requests,Inq_Id',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 'validation_error',
                    'errors' => $validator->errors()
                ], 422);
            }

            $viewer = InqStatusViewer::create($request->all());

            return response()->json([
                'status' => 'success',
                'message' => 'Inquiry status viewer added',
                'data' => $viewer
            ], 201);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 SHOW
    public function show($id)
    {
        try {
            $viewer = InqStatusViewer::find($id);

            if (!$viewer) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Record not found'
                ], 404);
            }

            return response()->json([
                'status' => 'success',
                'data' => $viewer
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 UPDATE
    public function update(Request $request, $id)
    {
        try {
            $viewer = InqStatusViewer::find($id);

            if (!$viewer) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Record not found'
                ], 404);
            }

            $validator = Validator::make($request->all(), [
                'Inq_St_Id' => 'required|exists:inquiry_statuses,Inq_St_Id',
                'U_Id'      => 'required|exists:users_masters,U_Id',
                'Inq_Id'    => 'required|exists:inquiry_requests,Inq_Id',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 'validation_error',
                    'errors' => $validator->errors()
                ], 422);
            }

            $viewer->update($request->all());

            return response()->json([
                'status' => 'success',
                'message' => 'Inquiry status viewer updated',
                'data' => $viewer
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 DELETE
    public function destroy($id)
    {
        try {
            $viewer = InqStatusViewer::find($id);

            if (!$viewer) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Record not found'
                ], 404);
            }

            $viewer->delete();

            return response()->json([
                'status' => 'success',
                'message' => 'Inquiry status viewer deleted'
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
