<?php

namespace App\Http\Controllers;

use App\Models\InquiryStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class InquiryStatusController extends Controller
{
    // LIST
    public function index()
    {
        try {
            $data = InquiryStatus::with('enquiry')->orderBy('Inq_St_Id', 'desc')->get();

            return response()->json([
                'status' => 'success',
                'data' => $data
            ]);
        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // STORE
    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Inq_Status' => 'required|string|max:255',
                'Inq_Id' => 'required|exists:inquiry_requests,Inq_Id'
            ]);

            if ($validator->fails()) {
                return response()->json(['status'=>'validation_error','errors'=>$validator->errors()],422);
            }

            $data = InquiryStatus::create($request->only('Inq_Status','Inq_Id'));

            return response()->json(['status'=>'success','message'=>'Inquiry status created','data'=>$data],201);

        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // SHOW
    public function show($id)
    {
        try {
            $data = InquiryStatus::with('enquiry')->find($id);

            if (!$data) {
                return response()->json(['status'=>'error','message'=>'Record not found'],404);
            }

            return response()->json(['status'=>'success','data'=>$data]);

        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // UPDATE
    public function update(Request $request, $id)
    {
        try {
            $data = InquiryStatus::find($id);

            if (!$data) {
                return response()->json(['status'=>'error','message'=>'Record not found'],404);
            }

            $validator = Validator::make($request->all(), [
                'Inq_Status' => 'required|string|max:255',
                'Inq_Id' => 'required|exists:inquiry_requests,Inq_Id'
            ]);

            if ($validator->fails()) {
                return response()->json(['status'=>'validation_error','errors'=>$validator->errors()],422);
            }

            $data->update($request->only('Inq_Status','Inq_Id'));

            return response()->json(['status'=>'success','message'=>'Inquiry status updated','data'=>$data]);

        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }

    // DELETE
    public function destroy($id)
    {
        try {
            $data = InquiryStatus::find($id);

            if (!$data) {
                return response()->json(['status'=>'error','message'=>'Record not found'],404);
            }

            $data->delete();

            return response()->json(['status'=>'success','message'=>'Inquiry status deleted']);

        } catch (Exception $e) {
            return response()->json(['status'=>'error','message'=>$e->getMessage()],500);
        }
    }
}
