<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\RoleMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class RoleMasterController extends Controller
{
    // 🔹 Get All Roles
    public function index()
    {
        try {
            return response()->json([
                'status' => 'success',
                'data' => RoleMaster::all()
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 Create Role
    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Role_Prefix' => 'required|max:5',
                'Role_Name'   => 'required|max:255',
                'TwoFacAuth'  => 'nullable|max:15'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 'validation_error',
                    'errors' => $validator->errors()
                ], 422);
            }

            $role = RoleMaster::create($request->all());

            return response()->json([
                'status' => 'success',
                'message' => 'Role created successfully',
                'data' => $role
            ], 201);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 Get Single Role
    public function show($id)
    {
        try {
            $role = RoleMaster::find($id);

            if (!$role) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Role not found'
                ], 404);
            }

            return response()->json([
                'status' => 'success',
                'data' => $role
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 Update Role
    public function update(Request $request, $id)
    {
        try {
            $role = RoleMaster::find($id);

            if (!$role) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Role not found'
                ], 404);
            }

            $validator = Validator::make($request->all(), [
                'Role_Prefix' => 'max:5',
                'Role_Name'   => 'max:255',
                'TwoFacAuth'  => 'max:15'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 'validation_error',
                    'errors' => $validator->errors()
                ], 422);
            }

            $role->update($request->all());

            return response()->json([
                'status' => 'success',
                'message' => 'Role updated successfully',
                'data' => $role
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    // 🔹 Delete Role
    public function destroy($id)
    {
        try {
            $role = RoleMaster::find($id);

            if (!$role) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Role not found'
                ], 404);
            }

            $role->delete();

            return response()->json([
                'status' => 'success',
                'message' => 'Role deleted successfully'
            ], 200);

        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
