<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InqReason extends Model
{
    protected $table = 'inq_reasons';
    protected $primaryKey = 'Inq_Res_Id';
    public $timestamps = false;

    protected $fillable = [
        'Inq_Reason',
        'Inq_Act_Id',
        'Inq_Id'
    ];

    public function action()
    {
        return $this->belongsTo(\App\Models\InqStatusAction::class, 'Inq_Act_Id', 'Inq_Act_Id');
    }

    public function enquiry()
    {
        return $this->belongsTo(\App\Models\InquiryRequest::class, 'Inq_Id', 'Inq_Id');
    }
}
