<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InqStatusAction extends Model
{
    protected $table = 'inq_status_actions';
    protected $primaryKey = 'Inq_Act_Id';
    public $timestamps = false;

    protected $fillable = [
        'Inq_St_Id',
        'Inq_Id',
        'Inq_Action',
        'Send_By',
        'Recepient'
    ];

    public function status()
    {
        return $this->belongsTo(\App\Models\InquiryStatus::class, 'Inq_St_Id', 'Inq_St_Id');
    }

    public function enquiry()
    {
        return $this->belongsTo(\App\Models\InquiryRequest::class, 'Inq_Id', 'Inq_Id');
    }
}
