<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InqStatusViewer extends Model
{
    use HasFactory;

    protected $table = 'inq_status_viewers';
    protected $primaryKey = 'Inq_StV_Id';

    protected $fillable = [
        'Inq_St_Id',
        'U_Id',
        'Inq_Id'
    ];

    public $timestamps = false;

       public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }

       public function inq_st()
    {
        return $this->belongsTo(InquiryStatus::class, 'Inq_St_Id', 'Inq_St_Id');
    }

         public function inq_Id()
    {
        return $this->belongsTo(InquiryRequest::class, 'Inq_Id', 'Inq_Id');
    }
}
