<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InquiryRequest extends Model
{
    protected $table = 'inquiry_requests';
    protected $primaryKey = 'Inq_Id';
    public $timestamps = true; // migration me timestamps add kiye hain

    protected $fillable = [
        'U_Id',        // ✅ FK added
        'Inq_Date',
        'Inq_Desc'
    ];

    // 🔹 Inquiry belongs to User
    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
