<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InquiryStatus extends Model
{
    protected $table = 'inquiry_statuses';
    protected $primaryKey = 'Inq_St_Id';
    public $timestamps = false;

    protected $fillable = [
        'Inq_Status',
        'Inq_Id'
    ];

    // Relationship with EnquiryRequest
    public function enquiry()
    {
        return $this->belongsTo(\App\Models\InquiryRequest::class, 'Inq_Id', 'Inq_Id');
    }
}
