<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RoleMapping extends Model
{
    protected $table = 'role_mappings';
    protected $primaryKey = 'URoleMap';

    protected $fillable = [
        'U_Id',
        'Role_Id',
        'Default_Rid'
    ];

    // 🔹 Relations
    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }

    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'Role_Id', 'Role_Id');
    }
}
