<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserMaster extends Model
{
    use HasFactory;

    protected $table = 'users_masters';
    protected $primaryKey = 'U_Id';

    protected $fillable = [
        'Role_Id',          // ✅ add this
        'U_Name',
        'U_Email',
        'U_Password',
        'U_Status',
        'U_Gender',
        'U_Mobile',
        'U_DOB',
        'U_Image',
        'FCM_Token'
    ];

    protected $hidden = ['U_Password'];

    // ✅ Relation with RoleMaster
    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'Role_Id', 'Role_Id');
    }
}
