<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('users_masters', function (Blueprint $table) {
            $table->bigIncrements('U_Id');
            $table->string('U_Name', 255);
            $table->string('U_Email', 225)->unique();
            $table->string('U_Password', 255);
            $table->string('U_Status', 1)->default('1');
            $table->string('U_Gender', 1)->nullable();
            $table->string('U_Mobile', 10)->required();
            $table->date('U_DOB')->nullable();
            $table->string('U_Image', 191)->nullable();
            $table->string('FCM_Token', 191)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users_masters');
    }
};
