<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('role_mappings', function (Blueprint $table) {
            $table->bigIncrements('URoleMap');
            $table->unsignedBigInteger('U_Id')->nullable();
            $table->unsignedBigInteger('Role_Id')->nullable();
            $table->integer('Default_Rid')->default(0);
            $table->timestamps();

            // Foreign Keys
            $table->foreign('U_Id')
                  ->references('U_Id')
                  ->on('users_masters')
                  ->onDelete('cascade');

            $table->foreign('Role_Id')
                  ->references('Role_Id')
                  ->on('role_masters')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('role_mappings');
    }
};
