<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('organisations', function (Blueprint $table) {
            $table->bigIncrements('Org_Id');
            $table->string('Org_Name', 255);
            $table->string('Org_Code', 50)->unique();
            $table->string('Org_GST_No', 50)->nullable();
            $table->string('Org_TDS_No', 50)->nullable();
            $table->string('Org_PAN_No', 20)->nullable();
            $table->text('Org_Address')->nullable();
            $table->string('Org_City', 100)->nullable();
            $table->string('Org_State', 100)->nullable();
            $table->string('Org_Pin', 10)->nullable();
            $table->string('Org_Email', 150)->nullable();
            $table->string('Org_Mobile', 15)->nullable();
            $table->string('Org_URL', 191)->nullable();
            $table->string('Org_Logo', 191)->nullable();
             $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('organisations');
    }
};
