<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('inquiry_statuses', function (Blueprint $table) {
            $table->bigIncrements('Inq_St_Id');
            $table->string('Inq_Status', 255);
            $table->unsignedBigInteger('Inq_Id');

            // Foreign key
            $table->foreign('Inq_Id')
                  ->references('Inq_Id')
                  ->on('inquiry_requests')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::table('inquiry_statuses', function (Blueprint $table) {
            $table->dropForeign(['Inq_Id']);
        });

        Schema::dropIfExists('inquiry_statuses');
    }
};
