<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('inq_status_actions', function (Blueprint $table) {
            $table->bigIncrements('Inq_Act_Id');
            $table->unsignedBigInteger('Inq_St_Id');
            $table->unsignedBigInteger('Inq_Id');
            $table->string('Inq_Action', 255);
            $table->string('Send_By', 255);
            $table->string('Recepient', 255);

            // Foreign keys
            $table->foreign('Inq_St_Id')
                  ->references('Inq_St_Id')
                  ->on('inquiry_statuses')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');

            $table->foreign('Inq_Id')
                  ->references('Inq_Id')
                  ->on('inquiry_requests')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::table('inq_status_actions', function (Blueprint $table) {
            $table->dropForeign(['Inq_St_Id']);
            $table->dropForeign(['Inq_Id']);
        });

        Schema::dropIfExists('inq_status_actions');
    }
};
