<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('inq_reasons', function (Blueprint $table) {
            $table->bigIncrements('Inq_Res_Id');
            $table->string('Inq_Reason', 255);
            $table->unsignedBigInteger('Inq_Act_Id');
            $table->unsignedBigInteger('Inq_Id');

            // Foreign keys
            $table->foreign('Inq_Act_Id')
                  ->references('Inq_Act_Id')
                  ->on('inq_status_actions')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');

            $table->foreign('Inq_Id')
                  ->references('Inq_Id')
                  ->on('inquiry_requests')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::table('inq_reasons', function (Blueprint $table) {
            $table->dropForeign(['Inq_Act_Id']);
            $table->dropForeign(['Inq_Id']);
        });

        Schema::dropIfExists('inq_reasons');
    }
};
