<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('users_masters', function (Blueprint $table) {
            $table->unsignedBigInteger('Role_Id')->nullable()->after('U_Id');

            $table->foreign('Role_Id')
                  ->references('Role_Id')
                  ->on('role_masters')
                  ->onDelete('restrict')
                  ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('users_masters', function (Blueprint $table) {
            $table->dropForeign(['Role_Id']);
            $table->dropColumn('Role_Id');
        });
    }
};
