<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ActivityLog', function (Blueprint $table) {
            $table->bigIncrements('user_act_log_id');

            $table->unsignedBigInteger('U_Id');
            $table->string('FootPrint', 100);
            $table->dateTime('StartDate');
            $table->dateTime('EndDate')->nullable();

            // 🔹 FK
            $table->foreign('U_Id')
                  ->references('U_Id')
                  ->on('users_masters')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ActivityLog');
    }
};
