<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('inq_status_viewers', function (Blueprint $table) {
            $table->bigIncrements('Inq_StV_Id');

            $table->unsignedBigInteger('Inq_St_Id');
            $table->unsignedBigInteger('U_Id');
            $table->unsignedBigInteger('Inq_Id');

            // 🔹 Foreign Keys
            $table->foreign('Inq_St_Id')
                  ->references('Inq_St_Id')
                  ->on('inquiry_statuses')
                  ->onDelete('cascade');

            $table->foreign('U_Id')
                  ->references('U_Id')
                  ->on('users_masters')
                  ->onDelete('cascade');

            $table->foreign('Inq_Id')
                  ->references('Inq_Id')
                  ->on('inquiry_requests')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inq_status_viewers');
    }
};
