<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');



use App\Http\Controllers\UserMasterController;
use App\Http\Controllers\RoleMasterController;
use App\Http\Controllers\RoleMappingController;
use App\Http\Controllers\OrganisationController;
use App\Http\Controllers\InquiryRequestController;
use App\Http\Controllers\InquiryStatusController;
use App\Http\Controllers\InqStatusActionController;
use App\Http\Controllers\InqReasonController;
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\InqStatusViewerController;


Route::post('login', [UserMasterController::class, 'login']);
Route::post('send-otp', [UserMasterController::class, 'sendOtp']);
Route::post('reset-password', [UserMasterController::class, 'resetPassword']);

Route::get('users', [UserMasterController::class, 'index']);
Route::get('users/{id}', [UserMasterController::class, 'show']);
Route::post('users', [UserMasterController::class, 'store']);
Route::put('users/{id}', [UserMasterController::class, 'update']);
Route::delete('users/{id}', [UserMasterController::class, 'destroy']);

Route::get('roles', [RoleMasterController::class, 'index']);
Route::get('roles/{id}', [RoleMasterController::class, 'show']);
Route::post('roles', [RoleMasterController::class, 'store']);
Route::put('roles/{id}', [RoleMasterController::class, 'update']);
Route::delete('roles/{id}', [RoleMasterController::class, 'destroy']);

Route::get('role-mappings', [RoleMappingController::class, 'index']);
Route::get('role-mappings/{id}', [RoleMappingController::class, 'show']);
Route::post('role-mappings', [RoleMappingController::class, 'store']);
Route::put('role-mappings/{id}', [RoleMappingController::class, 'update']);
Route::delete('role-mappings/{id}', [RoleMappingController::class, 'destroy']);


// Route::apiResource('organisations', OrganisationSettingController::class);
Route::get('organisations', [OrganisationController::class, 'index']);
Route::get('organisations/{id}', [OrganisationController::class, 'show']);
Route::post('organisations', [OrganisationController::class, 'store']);
Route::put('organisations/{id}', [OrganisationController::class, 'update']);
Route::delete('organisations/{id}', [OrganisationController::class, 'destroy']);


Route::get('inquiry', [InquiryRequestController::class, 'index']);
Route::post('inquiry', [InquiryRequestController::class, 'store']);
Route::get('inquiry/{id}', [InquiryRequestController::class, 'show']);
Route::put('inquiry/{id}', [InquiryRequestController::class, 'update']);
Route::delete('inquiry/{id}', [InquiryRequestController::class, 'destroy']);

Route::get('inquiry-status', [InquiryStatusController::class, 'index']);
Route::post('inquiry-status', [InquiryStatusController::class, 'store']);
Route::get('inquiry-status/{id}', [InquiryStatusController::class, 'show']);
Route::put('inquiry-status/{id}', [InquiryStatusController::class, 'update']);
Route::delete('inquiry-status/{id}', [InquiryStatusController::class, 'destroy']);


Route::get('inq-status-action', [InqStatusActionController::class, 'index']);
Route::post('inq-status-action', [InqStatusActionController::class, 'store']);
Route::get('inq-status-action/{id}', [InqStatusActionController::class, 'show']);
Route::put('inq-status-action/{id}', [InqStatusActionController::class, 'update']);
Route::delete('inq-status-action/{id}', [InqStatusActionController::class, 'destroy']);

Route::get('inq-reason', [InqReasonController::class, 'index']);
Route::post('inq-reason', [InqReasonController::class, 'store']);
Route::get('inq-reason/{id}', [InqReasonController::class, 'show']);
Route::put('inq-reason/{id}', [InqReasonController::class, 'update']);
Route::delete('inq-reason/{id}', [InqReasonController::class, 'destroy']);

// Route::apiResource('activity-logs', ActivityLogController::class);
Route::get('activity-logs', [ActivityLogController::class, 'index']);
Route::post('activity-logs', [ActivityLogController::class, 'store']);
Route::get('activity-logs/{id}', [ActivityLogController::class, 'show']);
Route::put('activity-logs/{id}', [ActivityLogController::class, 'update']);
Route::delete('activity-logs/{id}', [ActivityLogController::class, 'destroy']);


// Route::apiResource('inq-status-viewers', InqStatusViewerController::class);
Route::get('inq-status-viewers', [InqStatusViewerController::class, 'index']);
Route::post('inq-status-viewers', [InqStatusViewerController::class, 'store']);
Route::get('inq-status-viewers/{id}', [InqStatusViewerController::class, 'show']);
Route::put('inq-status-viewers/{id}', [InqStatusViewerController::class, 'update']);
Route::delete('inq-status-viewers/{id}', [InqStatusViewerController::class, 'destroy']);
